extends Node2D

@onready var bsprite = $Sprite2D
@onready var esprite = $Wizz_lvl1/Sprite2D
@onready var blurBox = $Blurbox
@onready var playerSprite = $Player/Sprite2D
@onready var Owl = $Owl


#########################
#		Level flow 		#
###############################################################
enum Levels {
	Wizard_Day,
	Wizard_Night,
	Forrest_Day,
	Forrest_Night
}

enum Creature {
	Wizard,
	Werewolf
}

var Encounter_Counter = 0
var Current_Level = Levels.Wizard_Day
var Encounter_Level = 0
###############################################################

###########################
#     Question arrays     #
###############################################################
var Questions_text = [
	"He ate a [cruntchy] carrot.",
	"The shop was [offerring] free gift wrapping.",
	"The man wore a watch on his [rist].","",
	####Level Two####
	"Our cat wears a [coller] with a bell.",
	"Wombats live underground in [burros].",
	"I took the card out of the [enverlope].","",
	####Level Three####
	"The rain made the campers [misrable].",
	"His toe became [swolen] after he kicked it.",
	"The outdoor light [attrax] many bugs when it is left on.","",
	####Level Four####
	"The army made the new [recroots] complete an obstacle course.",
	"The library has a rack of [broshures] about many subjects.",
	"Mum sighed with [impatients].","",
	####Level Five####
	"A lioness [fearcely] guards her cubs.",
	"We had to [detoor] through back streets \nbecause the highway was being repaired.",
	"The [graphick] designer is responsible for the layout of the magazine.","",
	####Level Six####
	"Maps have [simbols] to show vegetation and \n other significant features.",
	"The artist [skeched] the outline of the picture.",
	"A steep footpath provided the only [acess] to the \nremote cottage.","",
	####Level Seven####
	"The [passangers] on the bus were irritated by the\nloud conversation.",
	"The [futureistic] cars used innovative concepts\nand materials.",
	"I recently enrolled my naughty dog in\n[obediance] school.","",
	####Level Eight####
	"The marathon runner was [determind] to \ncomplete the challenging race.",
	"There are penalties for motorists caught\n[exeeding] the speed limit.",
	"The cyclists were [sponsered] to raise money for\ndeserving charities.","",
	####Level Nine####
	"T5 The actor used [exagerated] gestures to portray his emotions.",
	"The receptionist impressed clients \nwith his [buisnesslike] manner and hospitality.",
	"TThe nursery only stocks plants that are [tollerent] of desert conditions.","",
	####Level Ten####
	"There was widespread acclaim for the [amatuer] production.",
	"An [instantanious] reaction occurs when \nparticular chemicals are combined.",
	"Global communication is facilitated by [sattelites]\norbiting in space."
	
]

var Questions_Answer = [
	"crunchy", "offering", "wrist", "",
	####Level Two####
	"collar", "burrows", "envelope", "",
	####Level Three####
	"miserable", "swollen", "attracts", "",
	####Level Four####
	"recruits", "brochures", "impatience", "",
	####Level Five####
	"fiercely", "detour", "graphic", "",
	####Level Six####
	"symbols", "sketched", "access", "",
	####Level Seven#### 
	"passengers", "futuristic", "obedience", "",
	####Level Eight####
	"determined", "exceeding", "sponsored", "",
	####Level Nine####
	"exaggerated", "businesslike", "tolerant", "",
	####Level Ten####
	"amateur", "instantaneous", "satellites"
]

var Encounter_Messages = [
	"","","","","","","","","","","","",
	"","","","","","","","","","","","",
	"","","","","","","","","","","","",
	"","","","","","","","","","","","",
]

const Owl_Messages = [
	"Help young adventurer!
	The Evil warlock has made people forget how to spell 
	causing panic and chaos!
	Click on the evil wizard to do battle and restore
	peace to land but beware!\n The sands of time are not on your side",
	"Congratulations you have vanquished the first foe!
	You'll have to chase this next one through an 
	underground volcano.. Be careful!",
	"Ahoy there! seems we've got a pirate situtation.
	Make him walk the plank!",
	"Watch your step! This giant garden's landscaper
	seems to have eight legs and a taste for adventure!",
	"Ah, the graveyard shift!
	Beware, this worker never clocks out.",
	"Heads up!
	..Or should I say three?
	This host isn't too fond of visitors",
	"Keep a tight wrap on things
	 this desert’s inhabitant is more than just ancient history!",
	"Be Careful! \nThis one looks like it might have a \nbone to pick with you",
	"Beware of this cool customer \nhe really knows how to break the ice.
	 Watch out, or you might get a cold shoulder!",
	"Uh, oh! this time we've hit rock bottom. 
	This temple's bouncer is as tough as they come!",
	"Congratulations Adventurer!
	With your mastery of spelling you have beaten the evil
	and peace reigns again."
]

const Encounter_Backgrounds = [
	"",
	##Level 2##
	"", "", "res://Player/Cavern2.png","",
	##Level 3##
	"", "", "res://Player/PShip.png", "",
	##Level 4##
	"", "", "res://Player/GiantMeadow.png", "",
	##Level 5##
	"", "", "res://Player/Grave yard.png", "",
	##Level 6##
	"", "", "res://Player/Swamp.png", "",
	##Level 7##
	"", "", "res://Player/Desert.png", "",
	##Level 8##
	"", "", "res://Player/Dungeon.png", "",
	##Level 9##
	"", "", "res://Player/Iceland.png", "",
	##Level 10##
	"", "", "res://Player/Incan.png", "",
	#end
	"", "", "res://Player/End.png", ""
]

const Encounter_Sprites = [
	"",
	"", "", "res://Wizzard/Magma.png",
	"", "", "", "res://Wizzard/PirateL.png",
	"", "", "", "res://Wizzard/Giant Spider.png", 
	"", "", "", "res://Wizzard/Wraith.png",
	"", "", "", "res://Wizzard/Hydra.png",
	"", "", "", "res://Wizzard/Mummy.png",
	"", "", "", "res://Wizzard/Skeleton.png",
	"", "", "", "res://Wizzard/Iceman.png",
	"", "", "", "res://Wizzard/Golem.png"
]

const Question_prefix = "The word in brackets is spelt incorrectly. \nWrite the correct spelling into the answer box.\n"

var playerpositionsX = [ 
	280, 450, 800, 91, 278, 565, 767,
	55, 290, 521, 910,
	55, 290, 521, 910,
	55, 152, 497, 695, #wraith
	55, 290, 521, 910,
	55, 290, 521, 910,
	55, 290, 521, 910,
	55, 290, 521, 910,
	55, 290, 521, 910
] #280
var playerPositionsY = [ 
	243, 100, 243, 529, 426, 272, 9,
	323, 330, 230, 305,
	323, 330, 230, 305,
	306, 493, 394, 114, #Wraith
	323, 330, 230, 305,
	323, 330, 230, 305,
	323, 330, 230, 305,
	323, 330, 230, 305,
	323, 330, 230, 305
	]
var enemyPositionX = [
	387, 767, 214, 495, 495, 665,
	228, 228, 464, 847,
	228, 228, 464, 847,
	120, 423, 423, 606, #Wraith
	228, 228, 464, 847,
	228, 228, 464, 847,
	228, 228, 464, 847,
	228, 228, 464, 847,
	228, 228, 464, 847
	] #387
var enemyPositionY = [
	-40, 133, 282, 101, 101, -100,
	221, 221, 125, 190,
	221, 221, 125, 190,
	457, 212, 212, 0,   #Wraith
	221, 221, 125, 190,
	221, 221, 325, 190,
	221, 221, 125, 190,
	221, 221, 325, 190,
	221, 221, 325, 190
	]

var character_sprite = [
	"res://Player/Player.png",
	"res://Player/Player2.png",
	"res://Player/Player3.png"
]

var speech_box = null
var input_box = null
var speech_box_scene = preload("res://Speech.tscn")
var input_box_scene = preload("res://panel.tscn")
var toggle = true
var owlCount = 0

func _ready():
	speech_box = speech_box_scene.instantiate()
	add_child(speech_box)
	speech_box.visible = false
	Owl.show_message(Owl_Messages[owlCount])
	owlCount += 1
	$Wizz_lvl1.visible = false
	playerSprite.texture=load(character_sprite[Globals.character_number])
	pass

func _process(_delta):
	pass

func _on_wizz_lvl_1_monster_clicked():
	match Current_Level:
		Levels.Wizard_Day:
			if toggle == true:
				var target_node = $Player
				target_node.position.x = playerpositionsX[Encounter_Counter]
				target_node.position.y = playerPositionsY[Encounter_Counter]
				print("Player Position X:")
				print(target_node.position.x)
				print("Player Position Y:")
				print(target_node.position.y)
				skip()
				#speech_box.show_message(Encounter_Messages[Encounter_Counter])
			toggle = false
	pass

func skip():
	if toggle == toggle:
		speech_box.show_message(Question_prefix + '\n' + Questions_text[Encounter_Counter])
		input_box = input_box_scene.instantiate()
		add_child(input_box)
		speech_box.visible = true
		var callable = Callable(self, "_on_InputBox_ButtonClicked")
		input_box.connect("Button_Clicked", callable)
	pass


func _on_area_2d_boundry_clicked():
	if 100 == 100:
		speech_box.show_message(Question_prefix + '\n' + Questions_text[Encounter_Counter])
		input_box = input_box_scene.instantiate()
		add_child(input_box)
		speech_box.visible = true
		var callable = Callable(self, "_on_InputBox_ButtonClicked")
		input_box.connect("Button_Clicked", callable)
	pass

func _on_InputBox_ButtonClicked():
	if input_box.lineEdit.text  == Questions_Answer[Encounter_Counter] or input_box.lineEdit.text == "":
	#if 1 == 1:
		var target_node = $Wizz_lvl1
		if Encounter_Counter == 37:
			$Player.visible = false
			input_box.visible = false
			Owl.show_message(Owl_Messages[owlCount])
			bsprite.texture = load("res://Player/end.png")
		else:
			target_node.position.x = enemyPositionX[Encounter_Counter]
			target_node.position.y = enemyPositionY[Encounter_Counter]
			speech_box.visible = false
			input_box.visible = false
			toggle = true
			Encounter_Counter += 1
			Encounter_Level += 1
			print("Encounter_Counter:")
			print(Encounter_Counter)
			print("Encounter_Level")
			print(Encounter_Level)
			print("Enemy position X:")
			print(target_node.position.x)
			print("enemy position Y:")
			print(target_node.position.y)
			if Encounter_Level == 3:
				bsprite.texture = load(Encounter_Backgrounds[Encounter_Counter])
				esprite.texture = load(Encounter_Sprites[Encounter_Counter])
				print(esprite.texture.get_path())
				print(Encounter_Counter)
				var target_node2 = $Player
				target_node2.position.x = playerpositionsX[Encounter_Counter]
				target_node2.position.y = playerPositionsY[Encounter_Counter]
				print("Player Position X:")
				print(target_node2.position.x)
				print("Player Position Y:")
				print(target_node2.position.y)
				$Wizz_lvl1.visible = false
				blurBox.visible = true
				Owl.visible = true
				Owl.show_message(Owl_Messages[owlCount])
				Encounter_Counter += 1
				Encounter_Level = 0
				print("Encounter_Counter:")
				print(Encounter_Counter)
				print("Encounter_Level")
				print(Encounter_Level)
				owlCount += 1
	else:
		print("incorrect")
		get_tree().change_scene_to_file("res://Gameover.tscn")
	
	pass


func _on_owl_owl_clicked():
	if Encounter_Counter == 37:
		get_tree().change_scene_to_file("res://menu_screen.tscn")
	print("OWL")
	blurBox.visible = false
	Owl.visible = false
	$Wizz_lvl1.visible = true
	pass # Replace with function body.
